<?php
/**
 * GrL'Ca Dashboard Handler
 * 
 * Standardized version for grlca-prefixed plugins
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Prevent multiple loads
if ( ! function_exists( 'grlca_setup_dashboard' ) ) {

    /**
     * Check if any GrL'Ca plugin is currently active
     */
    function grlca_get_active_plugins() {
        $active_plugins = get_option( 'active_plugins', array() );
        $grlca_plugins = array();
        
        // Look for plugins starting with 'grlca-'
        foreach ( $active_plugins as $plugin ) {
            $plugin_slug = explode( '/', $plugin );
            if ( ! empty( $plugin_slug[0] ) && strpos( $plugin_slug[0], 'grlca-' ) === 0 ) {
                $grlca_plugins[] = $plugin;
            }
        }
        
        return $grlca_plugins;
    }

    /**
     * Setup GrL'Ca dashboard and main menu
     * ALWAYS create menu if GrL'Ca plugins are active
     */
    function grlca_setup_dashboard() {
        // Check if any GrL'Ca plugins are active
        $grlca_plugins = grlca_get_active_plugins();
        
        // If no GrL'Ca plugins are active, don't create menu
        if ( empty( $grlca_plugins ) ) {
            return;
        }
        
        // Check if menu already exists to avoid duplicates
        global $menu;
        $menu_exists = false;
        
        foreach ( $menu as $menu_item ) {
            if ( isset( $menu_item[2] ) && $menu_item[2] === 'grlca-dashboard' ) {
                $menu_exists = true;
                break;
            }
        }
        
        // If menu already exists, we're done
        if ( $menu_exists ) {
            return;
        }
        
        // Create the main menu
        add_menu_page(
            __( "GrL'Ca Dashboard", 'grlca' ),
            __( "GrL'Ca", 'grlca' ),
            'manage_options',
            'grlca-dashboard',
            'grlca_display_dashboard',
            'dashicons-admin-generic',
            58
        );
        
        // Add dashboard as first submenu item
        add_submenu_page(
            'grlca-dashboard',
            __( 'Dashboard', 'grlca' ),
            __( 'Dashboard', 'grlca' ),
            'manage_options',
            'grlca-dashboard',
            'grlca_display_dashboard'
        );
    }

    add_action( 'admin_menu', 'grlca_setup_dashboard' );

    /**
     * Display GrL'Ca Dashboard with iframe
     */
    function grlca_display_dashboard() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( __( 'You do not have sufficient permissions to access this page.', 'grlca' ) );
        }
        ?>
        <div class="wrap">
            <h1><?php _e( "GrL'Ca Dashboard", 'grlca' ); ?></h1>
            
            <div class="grlca-dashboard-container">
                <div class="card" style="padding: 0; margin: 0; border: none; box-shadow: none;">
                    <iframe 
                        src="https://grlca.com/grlca-wordpress-plugins/" 
                        style="width: 100vw; height: calc(100vh - 200px); border: none;"
                        frameborder="0"
                        scrolling="yes"
                        title="<?php _e( "GrL'Ca WordPress Plugins", 'grlca' ); ?>"
                    ></iframe>
                </div>
            </div>
        </div>
        <?php
    }

} // End prevent multiple loads