<?php
/**
 * Plugin Name: GrL'Ca Woo Slider
 * Description: Create multiple WooCommerce product sliders with category, count, Add-to-Cart toggle, and responsive settings.
 * Version: 2.9
 * Author: GrL'Ca
 * Text Domain: grlca-woo-slider
 * Requires Plugins: woocommerce
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants FIRST
define( 'GRLCA_WOO_SLIDER_VERSION', '2.9' );
define( 'GRLCA_WOO_SLIDER_URL', plugin_dir_url( __FILE__ ) );
define( 'GRLCA_WOO_SLIDER_PATH', plugin_dir_path( __FILE__ ) );
define( 'GRLCA_WOO_SLIDER_FILE', __FILE__ );

/**
 * Check if WooCommerce is active
 */
function grlca_woo_slider_check_woocommerce() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'grlca_woo_slider_woocommerce_notice' );
        return false;
    }
    return true;
}

function grlca_woo_slider_woocommerce_notice() {
    ?>
    <div class="notice notice-error">
        <p><strong>GrL'Ca Woo Slider:</strong> WooCommerce must be activated for this plugin to work.</p>
    </div>
    <?php
}

/**
 * Initialize the plugin
 */
function grlca_woo_slider_init() {
    if ( ! grlca_woo_slider_check_woocommerce() ) {
        return;
    }
    
    // Include the GrL'Ca dashboard handler FIRST
    require_once GRLCA_WOO_SLIDER_PATH . 'grlca-dashboard.php';
    
    // Include the main plugin class
    require_once GRLCA_WOO_SLIDER_PATH . 'includes/class-woo-product-slider-manager.php';
    
    // Initialize the plugin
    new GrLca_Woo_Product_Slider_Manager();
}

add_action( 'plugins_loaded', 'grlca_woo_slider_init' );

/**
 * Activation hook
 */
function grlca_woo_slider_activate() {
    // Set a transient to show admin notice on activation
    set_transient( 'grlca_woo_slider_activated', true, 30 );
}
register_activation_hook( __FILE__, 'grlca_woo_slider_activate' );

/**
 * Deactivation hook
 */
function grlca_woo_slider_deactivate() {
    // Clean up transients
    delete_transient( 'grlca_woo_slider_activated' );
}
register_deactivation_hook( __FILE__, 'grlca_woo_slider_deactivate' );